﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 2 April 2012
-- Description:   Gets a record from the HealthProviderIndividual Table
-- Modified:-
-- 22/10/2012  Changed to work with Hospital and PAS code
--						    HealthProviderIndividualId is not required at the moment
-- 24/04/2012  Changed LEFT OUTER to INNER joins to avoid locking with transactions
-- 29/09/2015 Added HealthProviderIndividualHpii
-- 14/01/2016 Updated joins so a record is returned when LocalProviderCode is passed in
-- 09/02/2016	Updated to return HealthProviderIndividual when Id is passed but not yet linked to Hospital
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderIndividualGet] 
(
	@HealthProviderIndividualId INT = NULL,
	@HospitalId INT = NULL,
	@PasProviderIdentifier VARCHAR(30) = NULL,
	@LocalProviderCode VARCHAR(256) = NULL,
	@IamProviderIdentifier VARCHAR(30) = NULL
) 
AS
BEGIN
	
	DECLARE @HealthProviderOrganisationNetworkId INT
	
	SELECT 
		@HealthProviderOrganisationNetworkId = hpo.HealthProviderOrganisationNetworkId
	FROM
		hips.Hospital h
	INNER JOIN
		hips.HealthProviderOrganisation hpo ON h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId
	WHERE 
		h.HospitalId = @HospitalId

	SELECT
		hcp.HealthProviderIndividualId,
		hcp.IamProviderIdentifier,
		hpih.Hpii,
		hpih.HpiiLastValidated,	
		hpih.HpiiStatusId,			
		hcp.TitleId,
		t.Description AS Title,		
		hcp.FamilyName,
		hcp.GivenNames,		
		hcp.SuffixId,
		s.Description AS Suffix,
		hcp.DeactivatedDate,
		hcp.LocalProviderCode,
		hcp.DateCreated,
		hcp.UserCreated,
		hcp.DateModified,
		hcp.UserModified
	FROM hips.HealthProviderIndividual AS hcp
	LEFT JOIN hips.HealthProviderIndividualHpii AS hpih ON hcp.HealthProviderIndividualId = hpih.HealthProviderIndividualId AND 
		hpih.HealthProviderOrganisationNetworkId = @HealthProviderOrganisationNetworkId
	LEFT JOIN hips.HospitalHealthProviderIndividual AS hhpi ON hcp.HealthProviderIndividualId = hhpi.HealthProviderIndividualId 
	INNER JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
	INNER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
	WHERE ((@HospitalId = hhpi.HospitalId AND @PasProviderIdentifier = hhpi.PasProviderIdentifier) OR (@PasProviderIdentifier IS NULL))
	AND (@HealthProviderIndividualId = hcp.HealthProviderIndividualId OR @HealthProviderIndividualId IS NULL)
	AND (@LocalProviderCode = hcp.LocalProviderCode OR @LocalProviderCode IS NULL)
	AND (@IamProviderIdentifier = hcp.IamProviderIdentifier OR @IamProviderIdentifier IS NULL)

END

GO
GRANT EXEC ON [hips].[HealthProviderIndividualGet] TO RunStoredProcedure
GO